/*********************************************************************
 *
 *	Hardware specific definitions
 *
 *********************************************************************
 * FileName:        HardwareProfile.h
 * Dependencies:    None
 * Processor:       PIC18, PIC24F, PIC24H, dsPIC30F, dsPIC33F, PIC32
 * Compiler:        Microchip C32 v1.10 or higher
 *					Microchip C30 v3.12 or higher
 *					Microchip C18 v3.34 or higher
 *					HI-TECH PICC-18 PRO 9.63PL2 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright (C) 2002-2009 Microchip Technology Inc.  All rights
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and
 * distribute:
 * (i)  the Software when embedded on a Microchip microcontroller or
 *      digital signal controller product ("Device") which is
 *      integrated into Licensee's product; or
 * (ii) ONLY the Software driver source files ENC28J60.c, ENC28J60.h,
 *		ENCX24J600.c and ENCX24J600.h ported to a non-Microchip device
 *		used in conjunction with a Microchip ethernet controller for
 *		the sole purpose of interfacing with the ethernet controller.
 *
 * You should refer to the license agreement accompanying this
 * Software for additional information regarding your rights and
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date		Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Howard Schlunder		10/03/06	Original, copied from Compiler.h
 * Ken Hesky            07/01/08    Added ZG2100-specific features
 ********************************************************************/

#define __HARDWARE_PROFILE_H

#include "GenericTypeDefs.h"
#include "Compiler.h"





//#define USE_SD_INTERFACE_WITH_SPI
#define USE_USB_INTERFACE


#define sw3                 PORTAbits.RA9
#define sw2                 PORTAbits.RA10
#define self_power 1
#define USB_BUS_SENSE  1 //      U1OTGSTATbits.SESVD
#define LED_GET()			(LATE)
#define LED_PUT(a)			(LATE = (a))



// Set configuration fuses (but only once)

  #define NULL_IO		0
	#define C1OUT_IO	1
	#define C2OUT_IO	2
	#define U1TX_IO		3
	#define U1RTS_IO	4
	#define U2TX_IO		5
	#define U2RTS_IO	6
	#define SDO1_IO		7
	#define SCK1OUT_IO	8
	#define SS1OUT_IO	9
	#define SDO2_IO		10
	#define SCK2OUT_IO	11
	#define SS2OUT_IO	12
	#define OC1_IO		18
	#define OC2_IO		19
	#define OC3_IO		20
	#define OC4_IO		21
	#define OC5_IO		22

   
	


// Clock frequency value.
// This value is used to calculate Tick Counter value

	#define GetSystemClock()		(32000000)      // Hz
	#define GetInstructionClock()	(GetSystemClock()/2)
	#define GetPeripheralClock()	GetInstructionClock()



// Hardware mappings
	#define LED0_TRIS			(TRISGbits.TRISG0)// RED BUTTON  PIN 75 PORTG BIT 0
	#define LED0_IO				(LATGbits.LATG0)  // GREEN BUTTON PIN 76 PORTE BIT 0
	#define LED1_TRIS			(TRISEbits.TRISE0)
	#define LED1_IO				(LATEbits.LATE0)
	#define LED2_TRIS			(TRISEbits.TRISE1)
	#define LED2_IO				(LATEbits.LATE1)
	#define LED3_TRIS			(TRISEbits.TRISE2)
	#define LED3_IO				(LATEbits.LATE2)
	#define LED4_TRIS			(TRISEbits.TRISE3)
	#define LED4_IO				(LATEbits.LATE3)
	#define LED5_TRIS			(TRISEbits.TRISE4)
	#define LED5_IO				(LATEbits.LATE4)

#define	LCD_RED  		(LATCbits.LATC14)
#define	LCD_GREEN  		(LATCbits.LATC13)
#define	LCD_BLUE  		(LATDbits.LATD11)



	
	// Select which UART the STACK_USE_UART and STACK_USE_UART2TCP_BRIDGE 
	// options will use.  You can change these to U1BRG, U1MODE, etc. if you 
	// want to use the UART1 module instead of UART2.
	#define UBRG					U2BRG
	#define UMODE					U2MODE
	#define USTA					U2STA
	#define BusyUART()				BusyUART2()
	#define CloseUART()				CloseUART2()
	#define ConfigIntUART(a)		ConfigIntUART2(a)
	#define DataRdyUART()			DataRdyUART2()
	#define OpenUART(a,b,c)			OpenUART2(a,b,c)
	#define ReadUART()				ReadUART2()
	#define WriteUART(a)			WriteUART2(a)
	#define getsUART(a,b,c)			getsUART2(a,b,c)
	#define putsUART(a)				putsUART2((unsigned int*)a)
	#define getcUART()				getcUART2()
	#define putcUART(a)				do{while(BusyUART()); WriteUART(a); while(BusyUART()); }while(0)
	#define putrsUART(a)			putrsUART2(a)





/*********************************************************************/
/******************* Pin and Register Definitions ********************/
/*********************************************************************/

/* SD Card definitions: Change these to fit your application when using
   an SD-card-based physical layer                                   */

      	#define GREEN_BUTTON_IO               PORTAbits.RA9
		#define RED_BUTTON_IO                PORTAbits.RA10
   		#define GREEN_BUTTON_TRIS			 TRISAbits.TRISA9
		#define RED_BUTTON_TRIS	         TRISAbits.TRISA10		

	
		
				// Registers for the SPI module you want to use
		
				// Description: The main SPI control register
        #define SPICON1             SPI2CON1
				// Description: The SPI status register
        #define SPISTAT             SPI2STAT
				// Description: The SPI Buffer
        #define SPIBUF              SPI2BUF
				// Description: The receive buffer full bit in the SPI status register
        #define SPISTAT_RBF         SPI2STATbits.SPIRBF
				// Description: The bitwise define for the SPI control register (i.e. _____bits)
        #define SPICON1bits         SPI2CON1bits
				// Description: The bitwise define for the SPI status register (i.e. _____bits)
        #define SPISTATbits         SPI2STATbits
				// Description: The enable bit for the SPI module
        #define SPIENABLE           SPISTATbits.SPIEN
		
				// Tris pins for SCK/SDI/SDO lines
		

// Macros for input and output TRIS bits
#define INPUT_PIN   1
#define OUTPUT_PIN  0


 //----------------------------
    // ZeroG ZG2100M WiFi I/O pins
    //----------------------------
	// If you have a ZeroG ZG2100M WiFi PICtail, you must uncomment one of 
	// these two lines to use it.  SPI1 is the top-most slot in the Explorer 16 
	// (closer to the LCD and prototyping area) while SPI2 corresponds to 
	// insertion of the PICtail into the middle of the side edge connector slot.
	#define ZG2100_IN_SPI1
	
	#define breakpoint_tris			(TRISGbits.TRISG8)
    #define breakpoint_io			(LATGbits.LATG8)
	#define UARTTX_TRIS	(TRISCbits.TRISC3)
	#define UARTTX_IO	(PORTCbits.RC3)
    #define UARTRX_TRIS			(TRISBbits.TRISB0)
	#define UARTRX_IO			(PORTBbits.RB0)
   
        // ZG2100 in SPI1 slot
		#define scope_trigger_tris	(TRISFbits.TRISF3)
    	#define scope_trigger		(LATFbits.LATF3)
        #define WF_CS_TRIS			(TRISFbits.TRISF0)
    	#define WF_CS_IO			(LATFbits.LATF0)
   //  BOB 1-31-2013   #define WF_RST_TRIS			(TRISGbits.TRISG1)	
   //  BOB 1-31-2013 	#define WF_RST_IO			(LATGbits.LATG1)

    	#define WF_HIBERNATE_TRIS	(TRISFbits.TRISF1)
    	#define WF_HIBERNATE_IO		(LATFbits.LATF1)
        #define WF_RESET_TRIS		(TRISGbits.TRISG1)	
    	#define WF_RESET_IO			(LATGbits.LATG1)







    // Registers for the SPI module you want to use
    	#define SPICON1		SPI2CON1
    	#define SPISTAT		SPI2STAT
    	#define SPIBUF		SPI2BUF
    	#define SPISTAT_RBF		SPI2STATbits.SPIRBF
    	#define SPICON1bits		SPI2CON1bits
    	#define SPISTATbits		SPI2STATbits
    	#define SPIENABLE           SPISTATbits.SPIEN

     
		#define WF_INT_TRIS	(TRISFbits.TRISF4)
		#define WF_INT_IO		(PORTFbits.RF4)
 
    	#define XCEN33_TRIS		    (TRISFbits.TRISF1)  
    	#define	XCEN33_IO			(PORTFbits.RF1)
    	
        #define WF_INT_EDGE		(INTCON2bits.INT1EP)
        #define WF_INT_IE			(IEC1bits.INT1IE)
        #define WF_INT_IF			(IFS1bits.INT1IF)
    

    	#define WF_SSPBUF			(SPI1BUF)
    	#define WF_SPISTAT			(SPI1STAT)
    	#define WF_SPISTATbits		(SPI1STATbits)
    
    	#define WF_SPICON1			(SPI1CON1)
       	#define WF_SPICON1bits		(SPI1CON1bits)
       	#define WF_SPICON2			(SPI1CON2)
       	#define WF_SPI_IE			(IEC0bits.SPI1IE)
    //    	#define ZG_SPI_IP			(IPC2bits.SPI1IP)
       	#define WF_SPI_IF			(IFS0bits.SPI1IF)
        
        #define ADE7758_INT_EDGE		(INTCON2bits.INT3EP)
        #define ADE7758_INT_IE			(IEC3bits.INT3IE)
        #define ADE7758_INT_IF			(IFS3bits.INT3IF)
		#define ADE7758_INT_TRIS		(TRISGbits.TRISG8)
		#define ADE7758_INT_IO			(PORTGbits.RG8)

//	// NOTE: You must also set the SPI_FLASH_SST/SPI_FLASH_SPANSION, 
//	//       SPI_FLASH_SECTOR_SIZE, and SPI_FLASH_PAGE_SIZE macros in 
//	//       SPIFlash.h to match your particular Flash memory chip!!!
	#define SPIFLASH_CS_TRIS		TRISDbits.TRISD13
	#define SPIFLASH_CS_IO			PORTDbits.RD13
	#define SPIFLASH_SCK_TRIS		TRISDbits.TRISD3
	#define SPIFLASH_SDI_TRIS		TRISDbits.TRISD4
	#define SPIFLASH_SDI_IO			PORTDbits.RD4
	#define SPIFLASH_SDO_TRIS		TRISDbits.TRISD2
	#define SPIFLASH_SPI_IF			(PIR1bits.SSPIF)
	#define SPIFLASH_SSPBUF			(SPI2BUF)
	#define SPIFLASH_SPICON1		(SPI2CON1)
	#define SPIFLASH_SPICON1bits	(SPI2CON1bits)
	#define SPIFLASH_SPICON2		(SPI2CON2)
	#define SPIFLASH_SPISTAT		(SPI2STAT)
	#define SPIFLASH_SPISTATbits	(SPI2STATbits)
